definition module EdMyIO;

/* OS dependent module */

/* Primitives which 'should be' in the standard CLEAN IO lib */

import StdFile, StdString, deltaEventIO;

	NoDate	:== {exists=False,yy=0,mm=0,dd=0,h=0,m=0,s=0};

::	DATE = {	exists	:: !Bool,
				yy		:: !Int,
				mm		:: !Int,
				dd		:: !Int,
				h		:: !Int,
				m		:: !Int,
				s		:: !Int };

/*	Opens a directory which can subsequently be read by 'FGetPlainFileName'.
	The boolean indicates whether the directory was successfully opened.
*/				
FOpenDir :: !String !Files -> (!Bool, !Files);

/*	Closes a directory which has been previously opened by 'FOpenDir'.
	The boolean indicates whether the directory was successfully closed.
*/				
FCloseDir :: !Files -> !(Bool, !Files);

/*	Returns the next file name in the directory wich is currently open.
	The boolean indicates whether there are still file names.
*/
FGetPlainFileName :: !Files -> (!Bool, !String, !Files);

/*	Returns True if the file name exists.
*/
FExists	:: !String !Files -> (!Bool, !Files);

/*	Removes the indicated file.
	The boolean indicates successfull removal.
*/
FRemove	:: !String !Files -> (!Bool, !Files);

/*	Returns the last modification date of the indicated file.
*/
FModified :: !String !Files -> (!DATE, !Files);

/*	Returns directory in which the indicated application resides.
*/
FStartUpDir :: !String !Files -> (!String, !Files);

/*	Checks whether the first date is older than the second one.
*/
Older_Date	:: !DATE !DATE -> Bool;

/*	Opens a directory selector dialog.
	Analogous to 'SelectInputFile'.
*/
SelectDir ::	!*s !(IOState *s) -> (!Bool, !String, !*s, !IOState *s);

/*	Launches the indicated appliaction.
	The result consists of a boolean indicating success, a result code returned by the
	application and the new program and io state.
*/
Launch ::	!String !*state !(IOState *state)
			-> (!Bool,!Int,!*state,!IOState *state);

ShiftKeyIsDown :: !(IOState .s) -> (!Bool, !IOState .s);


GetFullApplicationPath :: !*Files -> ({#Char}, *Files);
